/*******************************************************
Filename		:  	DW_station_select.sql
Release 		:  	STORET c2.0B
SIR			:  	1504
Description		:  	Creates a web page section that allows the user to select 
				stations to query Results. 
Author			:  	Joseph Wilson/Christine Tsang
Date			: 	June 20, 2003
                        	07/30/2003 - Changed labels from External Reference Scheme to Station Alias. -CT
                        	8/07/2003 - Added code to force focus on Org list when cursor lands on text box above it. -CT 
				8/08/2003 - Pass 0 instead of ALL when SELECT ALL is chosen for Org -JW
Comments		:  	Calls a pop-up window for Station selection. Code was extracted from dw_result_criteria_geo.
                        Called from other procedures.
**********************************************************/

SET DEF OFF;

CREATE or REPLACE PROCEDURE DW_station_select AS

--used to generate org list
CURSOR corg IS
SELECT pk_isn, organization_id, organization_name
FROM DI_ORG
ORDER BY organization_id;

BEGIN

htp.print('
<H4>Station</H4>
<table BORDER COLS=1 WIDTH="100%" >
<TR>
<TD>
<center>Select an Organization and a Search Type, then enter a Search String and click "Search Stations".
<br><br>
<INPUT TYPE="TEXT" READONLY style="font-size: 10pt; font-family: Courier New, Courier, monospace; font-weight: bold"  VALUE="ORG ID                              ORGANIZATION NAME" size="78"  onFocus="javascript:document.forms[1].D_ORG_LIST.focus()">
<font face="Courier, monospace"> <br>');
htp.print('<select name="D_ORG_LIST" tabindex="1" size="1" style="font: 10pt/12pt COURIER" onChange="javascript:document.forms[1].as_extref.value=''STANDARD'';document.forms[1].D_EXTREF_LIST.value=0">');
htp.formSelectOption('Select an Organization_____________________________________________________',cselected => 'TRUE', cattributes => 'VALUE="0"');		
FOR org IN corg LOOP
    htp.formSelectOption(org.organization_id||'~'||org.organization_name, cattributes => 'VALUE='||org.pk_isn);
END LOOP;

htp.print('</SELECT></font></center>
<table cols=2 width="100%">
<tr>
<td width="30%"></td>
<td align=left WIDTH="70%"><br><B>Search Type</B>
<br>&nbsp &nbsp &nbsp<input checked type=radio name="searchtype" tabindex="2" value="ID" > Search by Station ID
<BR>&nbsp &nbsp &nbsp<input type=radio name="searchtype" tabindex="3" value="Name"> Search by Station Name
<br>&nbsp &nbsp &nbsp<input type=radio name="searchtype" tabindex="4" value="Ref"> Search by Station Alias
<input type="hidden" name="D_EXTREF_LIST" value=0>
<br>&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp
Select Station Alias Type <input type="text" readonly value="STANDARD" name="as_extref" size="10" style="font: 10pt/12pt COURIER" onFocus="javascript:this.blur()">
<input type="button" tabindex="5" value="Look Up" onclick="javascript:document.forms[1].searchtype[2].checked=true;openWin(''extref'')" title="Opens a popup window for Station Alias Type selection">

<hr align=left width="70%">
<br><B>Search String </B>
<input type=hidden name="v_station_names">
<input type="text" name="as_station" tabindex="6" size="20" style="font: 10pt/12pt COURIER" maxlength="20" >
</td>
</tr>
</table>
<br><center><input type="button" tabindex="7" value="Search Stations" onclick="openWin(''station'')" title="Opens a popup window for Station selection">

<br><br><font style="font-size: 9pt; font-family: Courier New, Courier, monospace"> <select multiple size="10" name="station_list" style="font-size: 8pt; font-family: Courier New, Courier, monospace">
<option>Org ID~Station ID~Alias Type~Station Alias~Station Name</option>
<option value="dummy">____________________________________________________________________________________________________________________________</option>
</select></font>
<br>
<input type="button" tabindex="8" value="Clear Selected" onclick="javascript:deleteSelectedFromStationList();" title="Remove highlighted Stations from Selected List">
<input type="button" tabindex="9" value="Clear All" onclick="javascript:deleteAllFromStationList();" title="Remove all Stations from the Selected List">
</center>
</td>
</tr>
</table>
');

END;
/
SHOW ERRORS;